/**
 * Wrapper for handling errors during creation of menu items.
 * 
 * @param object createData 
 */ 
export async function addEntry(createData) {

    let { promise, resolve, reject } = Promise.withResolvers();
    let error;
    let id = browser.menus.create(createData, () => { 
        error = browser.runtime.lastError; // Either null or an Error object.
        if (error) {
            reject(error)
        } else {
            resolve();
        }
    });

    try {
        await promise;
        console.log("THEmailExtractor - Folder menu item installed.", createData); 
    } catch (error) {
        if (error.message.includes("already exists")) {
            console.info("THEmailExtractor - Folder menu item already exists.", createData);
        } else {
            console.error("THEmailExtractor - Failed to create folder menu item!", createData, error);
        }
    }

    return id;
}