import { msgIcons } from "/modules/tools.js"

const notificationId = "rbas-themailcrawler-notification";

/**
 * Displays extension notification.
 * 
 * @param string msg 
 * @param string icon (optional, 'ok' icon defualt)
 */
export async function showNotification(msg, icon = null) {

    await messenger.notifications.create(notificationId, {
        "type": "basic",
        "iconUrl": icon ? icon : msgIcons.ok,
        "title": browser.i18n.getMessage("extensionName"),
        "message": msg
    });

}

/**
 * Clears extension notification (if any).
 */
export async function clearNotification() {
    await messenger.notifications.clear(notificationId); 
}
