import * as tools from "/modules/tools.js"
import * as menu from "/modules/menu.js"
import * as emails from "/modules/emails.js"
import * as dlg from "/modules/info.js"
import * as addresses from "/modules/addresses.js"
import { ADDON_prefs } from '../options/options.js';

// Registration of menu item onClicked handler.
browser.menus.onClicked.addListener(async (info, tab) => {
    if (tools.isExtMenuItem(info.menuItemId)) {    
        try {
            console.log(`THEmailExtractor - Menu item "${info.menuItemId}" clicked.`);

            let folderId = info.selectedFolders[0].id; // first only

            // Get folder account.
            let account = await messenger.accounts.get(info.selectedFolders[0].accountId);

            // Prepare folder messages iterator.
            let messages = emails.getMessages(messenger.messages.list(folderId));

            // Retrieve email addresses from folder messages.
            
            console.log(`THEmailExtractor - Folder "${folderId}" (${account.name}}) messages are processing.`);
            dlg.showNotification(browser.i18n.getMessage("exportMsgStart"), tools.msgIcons.info) 

            // Get extension options.
            let settings = await ADDON_prefs.getPrefs([
                "pureEmailAddressOnly",
                "removeDuplicates"
            ]);

            if (tools.isExtClipboardMenuItem(info.menuItemId)) {
                await addresses.toClipboard(messages, folderId, account.name, settings); 
                dlg.showNotification(browser.i18n.getMessage("exportMsgOkToClipboard")) 
            } else {
                await addresses.toFile(messages, folderId, account.name, settings); 
                dlg.clearNotification(); // 'save as' dialog will be shown instead of confirmation notification
            }
        } 
        catch (error) {
            console.error(`THEmailExtractor - Folder messages processing error:`, error);
            if (tools.isExtClipboardMenuItem(info.menuItemId)) {
                dlg.showNotification(browser.i18n.getMessage("exportMsgErrorToClipboard"), tools.msgIcons.error);
            } else {
                dlg.showNotification(browser.i18n.getMessage("exportMsgErrorToFile"), tools.msgIcons.error);
            }
        }
    }
});

// Registration of extension menu items.
browser.runtime.onInstalled.addListener(async () => {
    // Email addresses to clipboard
    await menu.addEntry({
        id: tools.menuItemsIds.clipboard,
        title: browser.i18n.getMessage("menuItemClipboardTitle"), 
        contexts: ["folder_pane"],
        icons: tools.menuIcons.clipboard
    });
    // Email addresses to file.
    await menu.addEntry({
        id: tools.menuItemsIds.file,
        title: browser.i18n.getMessage("menuItemFileTitle"), 
        contexts: ["folder_pane"],
        icons: tools.menuIcons.file
    });
});