# THEmailExtractor ![Relative](/images/icon-48px.png)

**TH**underbird **Email Extractor**

*`For Thunderbird 128+`*

---

## Add-on Overview

A simple yet functional Thunderbird add-on that allows you to extract email addresses from a selected folder (without subfolders). Extracted email addresses are copied to the clipboard or exported to a text file. With this add-on you can quickly prepare a list of email addresses from your messages that can be used for many activities (mailing, statistics, etc.).

**Features**: 
* Exporting email addresses to the clipboard.
* Exporting email addresses to the file.

**Available languages** (in the menu and notification, partially based on Google Translator - please be understanding):
* EN (English) - default
* ES (Spanish)
* FR (French)
* DE (German)
* PL (Polish)

The selected language depends on your Thunderbird version. If the language set in Thunderbird is different from the above, English will be selected by default. All messages in the console are in English.

## Installation Instructions

Download installation package from [RBAS](https://rbas.pl/wp-content/uploads/2025/07/themailextractor.xpi).

Install add-on from downloaded file. 

**Required permissions**:
* Accounts (read),
* Menus,
* Messages (read),
* Notifications,
* Storage,
* Clipboard (write).

## Usage Guide

**Available config options**:
* **Pure email address only**.
"Andy \<andy@example.com>" => "andy\@example.com". 
Default = true (checked) - pure addresses only, no additional description.
* **Remove duplicates**. 
Default = true (checked) - no duplicates in exported addresses.

If ***Pure email address only*** option is unchecked (false), strings like: "***Andy \<andy@example.com>***" and "***Andy Brown <andy\@example.com>***" are not treated as the same - in this case there is no duplicate.

You can change options using ***Add-ons Manager*** and ***Optons*** tab.

![Relative](/images/screen-en-options.jpg)

After installation, the user has access to the add-on's features, which are located in the emails folder menu - see the figure below.

![Relative](/images/screen-en-menu.jpg)

Export result: **Email Addresses Object** (**EAO**) - I just added my drop to the ocean of shortcuts :-):

```
    {
        "account": "chosen_account",
        "folder": "chosen_account_folder",
        "recipients": [recipients-email-addresses-array],
        "cc": [cc-email-addresses-array],
        "bcc": [bcc-email-addresses-array],
        "authors": [authors-email-addresses-array],
    }
```

When starting the email address extracting process and after it is finished, the add-on displays a system notification or 'save as' dialog. Make sure you have notifications displayed if you want to see them.

![Relative](/images/notification.jpg)

In the case of a folder with many emails, the time between the initial and final notification may be quite long.

## Development Information

* Current version: `1.0.0.`
* THEmailExtractor is designed for Thunderbird 128+ and was created based on:
[WebExtension Documentation for Thunderbird 128 Manifest 3](https://webextension-api.thunderbird.net/en/128-esr-mv3/index.html).
* This add-on uses some code from https://github.com/micz/Thunderbird-Addon-Options-Manager
* Troubleshooting: `sendRemoveListener on closed conduit themailextractor@rbas.pl..` error is fired in console but extension is working, seems no action needed (I will keep an eye on it).

## License Information

* Icons: This add-on uses icons from Google's Material Icons, licensed under the [Apache License 2.0.](https://www.apache.org/licenses/LICENSE-2.0.txt)
* Software (this add-on code): Licensed under the [Mozilla Public License 2.0.](https://www.mozilla.org/en-US/MPL/2.0/)
* Copyright 2025 [RBAS](https://rbas.pl).